// 2003/03/18 FilesConfig.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// FilesJeS[̐ݒ܂B
	/// </summary>
	public class FilesConfig : IConfig
	{

		#region ݒ荀
		string comment = "0.0.0.0";
		/// <summary>
		/// ftHg̃t@CRg
		/// </summary>
		[ValueType("Quote")]
		public string Comment
		{
			get{return comment;}
			set
			{
				comment = Support.ProcessQuote( value );
			}
		}

		string fork = "cap";
		/// <summary>
		/// HFSG~[g̃t@Č`
		/// </summary>
		[ValueType("String")]
		public string Fork
		{
			get{return fork;}
			set
			{
				if( fork != "cap" && fork != "double"
					&& fork != "netatalk" && fork != string.Empty )
				{
					return;
				}
				fork =  value;
			}
		}
		#endregion

		public FilesConfig()
		{
		}

		public void Parse(Context context)
		{
			while(true)
			{
				string token = context.NextToken();
				if( token == null || token.Equals("}") )
				{
					break;
				}
				
				switch(token)
				{
					case"comment":
						this.Comment = context.NextToken();
						break;

					case"fork":
						this.Fork = context.NextToken();
						break;

					default:
						context.NextToken();
						break;
				}
			}
		}

		public System.Text.StringBuilder Save(System.Text.StringBuilder b)
		{
			ConfigWriter writer = new ConfigWriter( b );

			writer.StartCategory("files");
			writer.WriteComment("default comment for files that have none");
			writer.WriteQuoteProperty("comment" , this.Comment );
			writer.WriteLine();
			writer.WriteComment("--enable-hfs (default)");
			writer.WriteComment("format of hfs stuff: cap, double, netatalk");
			writer.WriteProperty("fork" , this.Fork );
			writer.EndCategory();

			return b;
		}
	}
}
